""" Sciencéthic Thermomètre numérique avec une sonde de température CTN branchée sur la broche
 analogique A0"""

from pyfirmata2Ext import Arduino, util
import time
from math import log            #importation des bibliothèques

#------------------------------- paramétrage de la communication---------------------------------------------

port = Arduino(Arduino.AUTODETECT)                  # la variable port contient le port de communication COM détecté automatiquement
util.Iterator(port).start()                         # itérateur permettant de ne pas saturer la liaison série
A0 = port.get_pin('a:0:i')                          # A0 désigne la broche analogique 0 (a:0) utilisée en entrée (:i)
time.sleep(0.5)                                     # délai d'attente pour la mise en place de la communication

#------------------------------- mesures --------------------------------------------------------------------

poursuite=True                                      # initialisation de la variable poursuite des mesures
while poursuite:                                    # tant qu'une mesure est à effectuer
    m=A0.read()                                     # lecture de la valeur sur la broche A0
    U=5*m                                           # calcul de la tension aux bornes de la résistance R1
    R=10000*(5-U)/U                                 # calcul la résistance de la thermistance
    temperature=-26.04*log(R)+265.26                # calcul de la temperature à partir de la courbe d'étalonnage sur tableur
    print('température =',round(temperature,1),'°C')# affichage de la valeur mesurée arrondie
    poursuite=input('Déclencher une nouvelle mesure o/n ? ')
    if poursuite=='n'or poursuite=='N':
        poursuite=False

port.exit()                                         # fermeture de la communication sur le port



